<?php
/**
 * Proceed to checkout button
 *
 * Contains the markup for the proceed to checkout button on the cart.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/proceed-to-checkout-button.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$total_product_quantity=0;

// echo '<pre>';
// print_r(WC()->cart->get_cart());
// echo '</pre>';


foreach(WC()->cart->get_cart() as $cart_item_key => $cart_item){
    $_product = wc_get_product( $cart_item['product_id'] );

   if($_product->is_type( 'simple' )){
      $total_product_quantity+=$cart_item['quantity'];
   }else{
       
   }
    
    
}

if((int)(($total_product_quantity)%6)==0){
    ?>
    <a href="<?php echo esc_url( wc_get_checkout_url() );?>" class="checkout-button button alt wc-forward TT">
        <?php esc_html_e( 'Fortsätt till kassan', 'woocommerce' ); ?>
    </a>

<?php
}else{
    ?>
    <a href="#" class="checkout-button button alt wc-forward xx" onclick="show_vine_cart_modal()">
        <?php esc_html_e( 'Fortsätt till kassan', 'woocommerce' ); ?>
    </a>
  <?php
}

?>

