<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

// global $product;
// echo '<pre>';
// print_r($args);
// echo '</pre>';

$labelledby = ! empty( $args['product_name'] ) ? sprintf( esc_html__( '%s quantity', 'woocommerce' ), strip_tags( $args['product_name'] ) ) : '';

?>

<?php if ( $max_value && $min_value === $max_value ): ?>
	<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
<?php else: ?>
	<div class="quantity">
		<label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php esc_html_e( 'Quantity', 'woocommerce' ); ?></label>
		<input
			type="number"
			id="<?php echo esc_attr( $input_id ); ?>"
			class="input-text qty text"
			step="<?php echo esc_attr( $step ); ?>"
			min="<?php
			if($args['product_type']==0){
			    echo 1;
			}else{
			   // echo esc_attr( $min_value );
			   echo 2;
			}
			
			?>"
			max="<?php echo esc_attr( 0 < $max_value ? $max_value : '' ); ?>"
			name="<?php echo esc_attr( $input_name ); ?>"
			value="<?php echo esc_attr( $input_value ); ?>"
			title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'woocommerce' ); ?>"
			size="4"
			pattern="<?php echo esc_attr( $pattern ); ?>"
			inputmode="<?php echo esc_attr( $inputmode ); ?>"
			aria-labelledby="<?php echo esc_attr( $labelledby ); ?>"
			data-product_type="<?php echo $args['product_type'];?>"
			/>

        <div style="width:30px;">
        <div style="height: 14px;padding-top: 10px;">
        <span value="" class="plus" style="border: none; background-color: transparent; cursor: pointer;display: block; float: left;" id="">
            <img src="<?php echo get_theme_file_uri().'/images/triangle_top.svg';?>" style="display: block;float: left;">
        </span>
         <div id="Qty_multiply"></div>
        </div>

        <div style="height: 14px;padding-top: 10px">
        <span value="" class="minus" style="border: none; background-color: transparent; cursor: pointer;display: block; float: left;" id="">
            <img src="<?php echo get_theme_file_uri().'/images/triangle_bottom.svg';?>" style="display: block;float: left;">
        </span>
        </div>

        </div>

	</div>
<?php endif; ?>
