<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

// global $product;

// echo '<pre>';
// print_r($product);
// echo '</pre>';

// if($product->is_type('simple')){
//     echo "simple product";
// }else{
//     echo "Variable product";
// }
//  exit();

//WC 3.4
$post_class = 'post_class';
if ( function_exists( 'WC' ) && WC()->version >= '3.4' ) {
	$post_class = 'wc_product_class';
}

?>
<script>
jQuery( document ).ready(function() {
    
      var is_batch_product='<?php
        $product1 = get_product( $post->ID );
        $reflect = new ReflectionClass($product1);
        if ($reflect->getShortName() =="WC_Product_Woosb"){
            echo 1;
        }else{
            echo 0;
        }
        ?>';
    
		if(is_batch_product == 1){
			jQuery(".Single_Left_R2 .quantity input").attr({ "min" : 1, "value" : 1 });
		}else {
			jQuery(".Single_Left_R2 .quantity input").attr({ "min" : 2, "value" : 2 });
		}
    
	//jQuery(".Single_Left_R2 .quantity input").attr({ "min" : 2, "value" : 2 });
	
	//var single_val = '<?php global $product; echo $product->get_regular_price//(); ?>';
	
	 if(is_batch_product==1){
        var single_val='<?php
            $product1 = get_product( $post->ID );
            echo $product1->get_sale_price();
            ?>';
            //console.log('Product 1 is '+single_val);
    }else{
        	var single_val = '<?php
        global $product;
        // echo $product->get_regular_price();
        if($product->get_sale_price() >0 || $product->get_sale_price() !='' ){
            echo $product->get_sale_price();
        }else{
            echo $product->get_regular_price();
        }
        ?>';
    }
	
	var tot_qty = jQuery('.Single_Left_R2 .quantity input').val();
	jQuery('#Qty_multiply').append('<p>' + (single_val*tot_qty).toFixed(0) + ':-</p>');

	jQuery('.Single_Left_R2 .quantity input').change(function(){
			console.log("changed");
			//alert(jQuery('.Single_Left_R2 .quantity input').val());
			// var single_val = $('.Single_Left_R1 .col-sm-6:first-child p:last-child');
// 			var single_val = '<?php global $product; echo $product//->get_regular_price(); ?>';
		
		 if(is_batch_product==1){
            var single_val='<?php
                $product1 = get_product( $post->ID );
                echo $product1->get_sale_price();
                ?>';
            //console.log('Product 1 is '+single_val);
        }else{
            	 var single_val = '<?php
        global $product;
        // echo $product->get_regular_price();
        if($product->get_sale_price() >0 || $product->get_sale_price() !='' ){
            echo $product->get_sale_price();
        }else{
            echo $product->get_regular_price();
        }
        ?>';
        }
		
			var tot_qty = jQuery('.Single_Left_R2 .quantity input').val();
			var tot_amount = (single_val * tot_qty).toFixed(0);
			tot_amount=addCommas(tot_amount);
			jQuery('#Qty_multiply').empty();
			jQuery('#Qty_multiply').append('<p>' + tot_amount + ':-</p>');
	});
	});
	
	function addCommas(nStr) {
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + '.' + '$2');
    }
    return x1 + x2;
}

</script>
<div class="Single_product_Begining">
<div class="single-breadcrumbs-wrapper">
	<div class="container">
		<?php basel_current_breadcrumbs( 'shop' ); ?>
		<?php if ( ! basel_get_opt( 'hide_products_nav' ) ): ?>
			<?php basel_products_nav(); ?>
		<?php endif ?>
	</div>
</div>

<div class="container">
	<?php
		/**
		 * Hook: woocommerce_before_single_product.
		 *
		 * @hooked wc_print_notices - 10
		 */
		 do_action( 'woocommerce_before_single_product' );

		 if ( post_password_required() ) {
		 	echo get_the_password_form();
		 	return;
		 }

		$product_images_class  	= basel_product_images_class();
		$product_summary_class 	= basel_product_summary_class();
		$single_product_class  	= basel_single_product_class();
		$content_class 			= basel_get_content_class();
		$product_design 		= basel_product_design();

		$container_summary = 'container';

		if( $product_design == 'sticky' ) {
			$container_summary = 'container-fluid';
		}

	?>
</div>
<div id="product-<?php the_ID(); ?>" <?php $post_class( $single_product_class ); ?>>

	<div class="<?php echo esc_attr( $container_summary ); ?>">

		<div class="row">
			<div class="product-image-summary <?php echo esc_attr( $content_class ); ?>">
				<div class="row">
					<div class="<?php echo esc_attr( $product_images_class ); ?> product-images Single_Left_column">
                        <div class="Green_badge mobile_view_green_badge">
                            <?php
                            $eko = get_field('eko_check');
                            if( $eko && in_array('show', $eko) ): ?>
                                <img src="<?php echo get_site_url() ?>/wp-content/uploads/2019/04/eko-1.png" />
                            <?php
                            endif;
                            ?>
                        </div>

                        <div class="col-sm-12 mobile_view_title"><h2><?php echo $product->get_title(); ?></h2></div>

                        <?php
							/**
							 * woocommerce_before_single_product_summary hook
							 *
							 * @hooked woocommerce_show_product_sale_flash - 10
							 * @hooked woocommerce_show_product_images - 20
							 */
							do_action( 'woocommerce_before_single_product_summary' );
						?>
            <?php global $product; ?>
            <div class="col-sm-12 Single_Left_R1">
                 <?php
                $product1 = get_product( $post->ID );
                $reflect = new ReflectionClass($product1);
                if ($reflect->getShortName() !="WC_Product_Woosb"){
                ?>
              <div class="col-sm-6"><p>750 cl flaska</p>
              
              <!--<p><?php
              
                    // if($product->get_sale_price() >0 || $product->get_sale_price() !=''){
                    //       echo $product->get_sale_price().':-';
                    //   }
                      
                    //   if($product->get_regular_price() >0 ||$product->get_regular_price()!=''){
                    //       echo $product->get_regular_price().':-';
                    //   }
                      
                      // ?></p> -->
               <p><?php
                      if($product->get_sale_price() >0 || $product->get_sale_price() !=''){
                          echo $product->get_sale_price().':-';
                      }
                     
                       if($product->get_regular_price() >0 ||$product->get_regular_price()!=''){
                          if($product->get_sale_price() >0 || $product->get_sale_price() !=''){
                              echo '<span style="text-decoration: line-through; padding-left:16px;">'.$product->get_regular_price().'</span>'.':-';
                          }else{
                              echo '<span>'.$product->get_regular_price().'</span>'.':-';
                          }
                      }

                       ?></p>
              
              
              
              
              
              
              </div>
              <?php } ?>
              
              
              <div class="col-sm-6" style="<?php if($reflect->getShortName() =="WC_Product_Woosb"){
                  ?>
                      border-right: none !important;
                      <?php
              }?>">
                  <p>låda med 6 flaskor</p>
                   <p><?php
                  //echo get_field( '6_bottles_price' );
//                      if($product->get_sale_price() )
     if($reflect->getShortName() =="WC_Product_Woosb"){
                      //echo '<div class="woosb-total woosb-text"></div>';
                      ?>
				  		<p><?php echo $product->get_sale_price();?>:- <span style="text-decoration: line-through; padding-left:16px;"><?php echo $product->get_regular_price();?>:-</span></p>
				  		
				  		
                      <?php
                    }else{
                         if($product->get_sale_price() >0 || $product->get_sale_price() !=''){
                                              $six_bottle_price=$product->get_sale_price()*6;
                                              echo $six_bottle_price.' :-';
                                          }else{
                                              $six_bottle_price=$product->get_regular_price()*6;
                                              echo $six_bottle_price. ':-';
                                          }
                    }
                  ?></p>
                  
              </div>
            </div>
            <div class="col-sm-12 Single_Left_R2">
              <?php do_action( 'woocommerce_single_product_summary' ); ?>
<!--							<div id="Qty_multiply"></div>-->
            </div>
            <div class="col-sm-12 Single_Left_R3" style="<?php
                 if($reflect->getShortName() =="WC_Product_Woosb"){
                     ?>
                     display:none;
                     <?php
                 }else{
                     display:block;
                 }
            ?>">
                <p><?php echo get_field( 'product_note' ); ?>:-</p>
            </div>
					</div>
					<div class="<?php echo esc_attr( $product_summary_class ); ?> summary entry-summary">
						<div class="summary-inner <?php if( $product_design == 'compact' ) echo 'basel-scroll'; ?>">
							<div class="basel-scroll-content">
								<?php
									/**
									 * Hook: woocommerce_single_product_summary.
									 *
									 * @hooked woocommerce_template_single_title - 5
									 * @hooked woocommerce_template_single_rating - 10
									 * @hooked woocommerce_template_single_price - 10
									 * @hooked woocommerce_template_single_excerpt - 20
									 * @hooked woocommerce_template_single_add_to_cart - 30
									 * @hooked woocommerce_template_single_meta - 40
									 * @hooked woocommerce_template_single_sharing - 50
									 */



                      $producent = $product->get_attribute( 'producent' );
                      $region = $product->get_attribute( 'land-region' );
                      $img_url = '';
                      //echo "Hello";
                      echo $product->get_attribute( 'name' ); 
                     // echo $region;
                      ?>
                <div class="Single_Right_column">
                  <div class="Green_badge desktop_view_green_badge">
                    <?php
                    $eko = get_field('eko_check');
                    if( $eko && in_array('show', $eko) ): ?>
                    <img src="<?php echo get_site_url() ?>/wp-content/uploads/2019/04/eko-1.png" />
                    <?php
                    endif;
                    ?>
                  </div>
                  <div class="col-sm-12 desktop_view_title">
                      <h2><?php echo $product->get_title(); ?></h2></div>
                      
                    <?php
                    $product1 = get_product( $post->ID );
                    $reflect = new ReflectionClass($product1);
//                    echo $reflect->getShortName();
//                    if ($reflect->getShortName() === 'Name') {
//                        // do this
//                    }
                   // print_r($product1);
                   if ($reflect->getShortName()=="WC_Product_Woosb"){

                    //  echo "product is grouped";
                       ?>
                       <div class="col-sm-12 group_product_desc">
                           <?php
                           echo  $product->get_short_description();
                           ?>
                       </div>
                       <div class="col-sm-12 group_product_cont_title">
                           <p>Läs mer om vinerna här:</p>
                       </div>

                       <div class="col-sm-12 group_product_list">
                        <?php
//                        echo "<pre>";
//                        print_r($product);
//                        echo "</pre>";
                        $rel_products = $product->get_upsells();

                        //print_r($product->get_items());

                        //CREATE ARRAY OF IDS
                        $woosb_items=$product->get_items();



                        foreach ($woosb_items as $woosb_item){
                            $woosb_product = wc_get_product( $woosb_item['id'] );
                                ?>
                                <div class="col-lg-12 group_product_item">
                                    <a href="<?php echo $woosb_product->get_permalink();?>">
                                        <?php echo $woosb_product->get_title();?>
                                    </a>
                                </div>
                                <?php

//                            echo $product->get_price_html();
                        }


//                        print_r($children);
                        ?>
                       </div>

                       <div class="col-sm-12 Single_Right_R6">
                           <div class="col-sm-12 product_short_description" style="border-bottom: none;">
                           </div>
                           <a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>">tillbaka till alla viner</a>
                       </div>

                       <?php
                   }else{
                       ?>
                  <div class="col-sm-12 Flag_Row">
                    <div class="col-sm-6"><p><?php echo $region;?></p></div>
                    <div class="col-sm-6"> <?php
// 					if( $region == 'Italien' ){ $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4-1.svg"; }
//                     else if ($region == 'Spanien') { $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4.svg"; }
//                     else if ($region == 'Frankrike') { $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4-2.svg"; }
//                     echo '<img src="'.$img_url.'" />'; 
						$thePostIdArray = explode(', ', $region);
                        $related_country_arr=array();
                        $img_url="";

                        foreach ($thePostIdArray as $key=>$value){
                            if($value=='Italien'){
                                array_push($related_country_arr,$value);
                            }elseif ($value=='Spanien'){
                                array_push($related_country_arr,$value);
                            }elseif ($value == 'Frankrike'){
                                array_push($related_country_arr,$value);
                            }
                        }
                        foreach ($related_country_arr as $key=>$value){
                            if($value=='Italien'){
                                $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4-1.svg";
                                echo '<img src="'.$img_url.'" />&nbsp';
                            }

                            if($value=='Spanien'){
                                $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4.svg";
                                echo '<img src="'.$img_url.'" />&nbsp';
                            }

                            if($value=='Frankrike'){
                                $img_url = get_site_url() . "/wp-content/uploads/2018/02/group-4-2.svg";
                                echo '<img src="'.$img_url.'" />&nbsp';
                            }
                        }
						?></div>
                  </div>
                  <div class="col-sm-12 Single_Right_R3">
                    <div class="col-sm-6"><p>årgång</p><p><?php echo get_field( 'argang' ); ?> </p></div>
                    <div class="col-sm-6"><p>alkoholhalt</p><p><?php echo get_field( 'alkoholhalt' ); ?> </p></div>
                  </div>
                  <div class="col-sm-12 Single_Right_R4">
                      <div class="col-sm-3">
                          <img src="<?php echo get_theme_file_uri();?>/images/vindruva.svg">
                      </div>
                      <div class="col-sm-9">
                          <p><?php echo get_field( 'ingredienti' ); ?> </p>
                      </div>
                  </div>
                  <div class="col-sm-12 Single_Right_R5">
                    <div class="col-sm-6"><p>Producent:</p><p><?php echo $product->get_attribute( 'producent' ); ?> </p></div>
                    <div class="col-sm-6"><img src="<?php echo get_site_url() ?>/wp-content/uploads/2019/04/group-37.svg" /></div>
                  </div>
                  <div class="col-sm-12 Single_Right_R6">
                      <div class="col-sm-12 product_short_description" style="border-bottom: none;">
                          <?php
                          echo  $product->get_short_description();
                          ?>
                      </div>
                    <?php //echo get_field( 'description' ); ?>
                    <a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>">tillbaka till alla viner</a>
                  </div>
                  <?php } ?>
                  
                  
                </div>
								<?php if ( $product_design != 'alt' && $product_design != 'sticky' && basel_get_opt( 'product_share' ) ): ?>
									<div class="product-share">
										<span class="share-title"><?php _e('Share', 'basel'); ?></span>
										<?php echo basel_shortcode_social( array( 'type' => basel_get_opt( 'product_share_type' ), 'size' => 'small', 'align' => 'left' ) ); ?>
									</div>
								<?php endif ?>
							</div>
						</div>
					</div>
				</div><!-- .summary -->
			</div>

			<?php
				/**
				 * woocommerce_sidebar hook
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>

		</div>
	</div>

	<?php if ( ( $product_design == 'alt' || $product_design == 'sticky' ) && basel_get_opt( 'product_share' ) ): ?>
		<div class="product-share">
			<?php echo basel_shortcode_social( array( 'type' => basel_get_opt( 'product_share_type' ), 'style' => 'colored' ) ); ?>
		</div>
	<?php endif ?>

	<div class="container">
		<?php
			/**
			 * basel_after_product_content hook
			 *
			 * @hooked basel_product_extra_content - 20
			 */
			do_action( 'basel_after_product_content' );
		?>
	</div>

	<?php if( $product_design != 'compact' ): ?>

		<div class="product-tabs-wrapper">
			<div class="container">
				<div class="row">
					<div class="col-sm-12">
						<?php
							/**
							 * woocommerce_after_single_product_summary hook
							 *
							 * @hooked woocommerce_output_product_data_tabs - 10
							 * @hooked woocommerce_upsell_display - 15
							 * @hooked woocommerce_output_related_products - 20
							 */
							do_action( 'woocommerce_after_single_product_summary' );
						?>
					</div>
				</div>
			</div>
		</div>

	<?php endif ?>

</div><!-- #product-<?php the_ID(); ?> -->
</div>
<?php do_action( 'woocommerce_after_single_product' ); ?>
